/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands.Home;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Commands.Home.HomeCommand;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.SimplifiedLocation;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Home
extends HomeCommand {
    public Home() {
        this.permNode = "admincmd.tp.home";
        this.cmdName = "bal_home";
    }

    @Override
    public void execute(CommandSender sender, CommandArgs args) throws ActionNotPermitedException, PlayerNotFound {
        if (Utils.isPlayer(sender)) {
            Player player = (Player)sender;
            be.Balor.Tools.Home home = null;
            home = Utils.getHome(sender, args.getString(0));
            if (home == null) {
                return;
            }
            Location loc = ACPlayer.getPlayer(home.player).getHome(home.home);
            if (loc == null) {
                Utils.sI18n(sender, "errorMultiHome", "home", home.home);
                return;
            }
            ACPluginManager.getScheduler().scheduleSyncDelayedTask((Plugin)ACHelper.getInstance().getCoreInstance(), (Runnable)new DelayedTeleport(loc, player, home, sender), ConfigEnum.TP_DELAY.getLong());
        }
    }

    @Override
    public boolean argsCheck(String ... args) {
        return args != null;
    }

    private class DelayedTeleport
    implements Runnable {
        protected SimplifiedLocation locBefore;
        protected Location teleportToLoc;
        protected Player target;
        protected be.Balor.Tools.Home home;
        protected CommandSender sender;

        public DelayedTeleport(Location teleportLoc, Player target, be.Balor.Tools.Home home2, CommandSender sender) {
            this.target = target;
            this.locBefore = new SimplifiedLocation(target.getLocation());
            this.teleportToLoc = teleportLoc;
            this.home = home2;
            this.sender = sender;
        }

        @Override
        public void run() {
            if (!ConfigEnum.CHECKTP.getBoolean()) {
                Utils.teleportWithChunkCheck(this.target, this.teleportToLoc);
                Utils.sI18n(this.sender, "multiHome", "home", this.home.home);
                return;
            }
            if (this.locBefore.equals(this.target.getLocation())) {
                Utils.teleportWithChunkCheck(this.target, this.teleportToLoc);
                Utils.sI18n(this.sender, "multiHome", "home", this.home.home);
            } else {
                Utils.sI18n(this.sender, "errorMoved", "cmdname", "Home");
            }
        }
    }
}

