/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands;

import be.Balor.Manager.Commands.CommandArgs;
import be.Balor.Manager.Exceptions.CommandAlreadyExist;
import be.Balor.Manager.Exceptions.CommandNotFound;
import be.Balor.Manager.Exceptions.PlayerNotFound;
import be.Balor.Manager.Permissions.ActionNotPermitedException;
import be.Balor.Manager.Permissions.PermChild;
import be.Balor.Manager.Permissions.PermParent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.AbstractAdminCmdPlugin;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public abstract class CoreCommand {
    protected String permNode = "";
    protected String cmdName = "";
    protected Permission bukkitPerm = null;
    protected PermissionDefault bukkitDefault = PermissionDefault.OP;
    protected boolean other = false;
    protected PluginCommand pluginCommand;
    protected final AbstractAdminCmdPlugin plugin;
    protected PermParent permParent;

    public CoreCommand(String name, String perm) {
        this.permNode = perm;
        this.cmdName = name;
        this.plugin = ACPluginManager.getCorePlugin();
    }

    public CoreCommand() {
        this.plugin = ACPluginManager.getCorePlugin();
    }

    public CoreCommand(String name, String perm, String plugin) {
        this.permNode = perm;
        this.cmdName = name;
        this.plugin = ACPluginManager.getPluginInstance(plugin);
    }

    public CoreCommand(String name, String perm, String plugin, PermParent parent) {
        this.permNode = perm;
        this.cmdName = name;
        this.plugin = ACPluginManager.getPluginInstance(plugin);
        this.permParent = parent;
    }

    public abstract void execute(CommandSender var1, CommandArgs var2) throws ActionNotPermitedException, PlayerNotFound;

    public abstract boolean argsCheck(String ... var1);

    public boolean permissionCheck(CommandSender sender) {
        if (this.permNode != null && !this.permNode.isEmpty()) {
            return PermissionManager.hasPerm(sender, this.bukkitPerm);
        }
        return true;
    }

    public String getCmdName() {
        return this.cmdName;
    }

    public String getPermNode() {
        return this.permNode;
    }

    public void registerBukkitPerm() {
        if (this.permNode != null && !this.permNode.isEmpty()) {
            if (this.permParent != null) {
                PermChild child = new PermChild(this.permNode, this.bukkitDefault);
                this.permParent.addChild(child);
                this.bukkitPerm = child.getBukkitPerm();
                if (this.other) {
                    this.permParent.addChild(new PermChild(this.permNode + ".other", this.bukkitDefault));
                }
                return;
            }
            this.bukkitPerm = this.plugin.getPermissionLinker().addPermChild(this.permNode, this.bukkitDefault);
            if (this.other) {
                this.plugin.getPermissionLinker().addPermChild(this.permNode + ".other", this.bukkitDefault);
            }
        }
    }

    public boolean toOther() {
        return this.other;
    }

    public void initializeCommand() throws CommandNotFound, CommandAlreadyExist {
        this.pluginCommand = this.plugin.getCommand(this.cmdName);
        if (this.pluginCommand == null) {
            throw new CommandNotFound(this.cmdName + " is not loaded in bukkit. Command deactivated");
        }
        if (this.pluginCommand.getAliases().isEmpty()) {
            throw new CommandAlreadyExist(this.cmdName + " has all his alias already registered. Command deactivated");
        }
    }

    public PluginCommand getPluginCommand() {
        return this.pluginCommand;
    }

    public AbstractAdminCmdPlugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return "CoreCommand [permNode=" + this.permNode + ", cmdName=" + this.cmdName + ", plugin=" + (Object)((Object)this.plugin) + ", permParent=" + this.permParent + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bukkitDefault == null ? 0 : this.bukkitDefault.hashCode());
        result = 31 * result + (this.cmdName == null ? 0 : this.cmdName.hashCode());
        result = 31 * result + (this.other ? 1231 : 1237);
        result = 31 * result + (this.permNode == null ? 0 : this.permNode.hashCode());
        result = 31 * result + (this.permParent == null ? 0 : this.permParent.hashCode());
        result = 31 * result + (this.plugin == null ? 0 : this.plugin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreCommand)) {
            return false;
        }
        CoreCommand other = (CoreCommand)obj;
        if (this.bukkitDefault != other.bukkitDefault) {
            return false;
        }
        if (this.cmdName == null ? other.cmdName != null : !this.cmdName.equals(other.cmdName)) {
            return false;
        }
        if (this.other != other.other) {
            return false;
        }
        if (this.permNode == null ? other.permNode != null : !this.permNode.equals(other.permNode)) {
            return false;
        }
        if (this.permParent == null ? other.permParent != null : !this.permParent.equals(other.permParent)) {
            return false;
        }
        return !(this.plugin == null ? other.plugin != null : !this.plugin.equals((Object)other.plugin));
    }
}

