/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Manager.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandArgs
implements Iterable<String> {
    protected final List<String> parsedArgs;
    protected final Map<Character, String> valueFlags = new HashMap<Character, String>();
    protected final Set<Character> booleanFlags = new HashSet<Character>();
    public int length;

    public CommandArgs(String args) {
        this(args.split(" "));
    }

    public CommandArgs(String[] args) {
        ArrayList<Integer> argIndexList = new ArrayList<Integer>(args.length);
        ArrayList<String> argList = new ArrayList<String>(args.length);
        block3: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.length() == 0) continue;
            argIndexList.add(i);
            switch (arg.charAt(0)) {
                case '\"': 
                case '\'': {
                    int endIndex;
                    StringBuilder build = new StringBuilder();
                    char quotedChar = arg.charAt(0);
                    for (endIndex = i; endIndex < args.length; ++endIndex) {
                        String arg2 = args[endIndex];
                        if (arg2.charAt(arg2.length() - 1) == quotedChar) {
                            if (endIndex != i) {
                                build.append(' ');
                            }
                            build.append(arg2.substring(endIndex == i ? 1 : 0, arg2.length() - 1));
                            break;
                        }
                        if (endIndex == i) {
                            build.append(arg2.substring(1));
                            continue;
                        }
                        build.append(' ').append(arg2);
                    }
                    if (endIndex < args.length) {
                        arg = build.toString();
                        i = endIndex;
                    }
                    if (arg.length() == 0) continue block3;
                }
                default: {
                    argList.add(arg);
                }
            }
        }
        ArrayList originalArgIndices = new ArrayList(argIndexList.size());
        this.parsedArgs = new ArrayList<String>(argList.size());
        int nextArg = 0;
        while (nextArg < argList.size()) {
            String arg;
            if ((arg = (String)argList.get(nextArg++)).charAt(0) == '-' && arg.length() > 1 && arg.matches("^-[a-zA-Z]+$")) {
                for (int i = 1; i < arg.length(); ++i) {
                    char flagName = arg.charAt(i);
                    if (this.valueFlags.containsKey(Character.valueOf(flagName))) continue;
                    if (nextArg >= argList.size()) {
                        this.booleanFlags.add(Character.valueOf(flagName));
                        continue;
                    }
                    this.valueFlags.put(Character.valueOf(flagName), (String)argList.get(nextArg));
                }
                continue;
            }
            originalArgIndices.add(argIndexList.get(nextArg - 1));
            this.parsedArgs.add(arg);
        }
        this.length = this.parsedArgs.size();
    }

    public String getString(int index) {
        try {
            String result = this.parsedArgs.get(index);
            if (result == null) {
                return null;
            }
            return result;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public int getInt(int index) throws NumberFormatException {
        return Integer.parseInt(this.getString(index));
    }

    public float getFloat(int index) throws NumberFormatException {
        return Float.parseFloat(this.getString(index));
    }

    public double getDouble(int index) throws NumberFormatException {
        return Double.parseDouble(this.getString(index));
    }

    public long getLong(int index) throws NumberFormatException {
        return Long.parseLong(this.getString(index));
    }

    public boolean hasFlag(char ch) {
        return this.booleanFlags.contains(Character.valueOf(ch)) || this.valueFlags.containsKey(Character.valueOf(ch));
    }

    public String getValueFlag(char flag) {
        String result = this.valueFlags.get(Character.valueOf(flag));
        if (result == null) {
            return null;
        }
        if (this.parsedArgs.remove(result)) {
            --this.length;
        }
        return result;
    }

    public String toString() {
        return Arrays.toString(this.parsedArgs.toArray(new String[0])) + " BoolFlags : " + Arrays.toString((Object[])this.booleanFlags.toArray(new Character[0])) + " ValFlags : " + (this.valueFlags.isEmpty() ? "[]" : "[" + this.valueFlagsToString() + "]");
    }

    private String valueFlagsToString() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<Character, String> entry : this.valueFlags.entrySet()) {
            buffer.append(entry.getKey()).append("->").append(entry.getValue()).append(", ");
        }
        buffer.deleteCharAt(buffer.length() - 1).deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.parsedArgs.iterator();
    }
}

