/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners.Features;

import be.Balor.Listeners.Events.ACSignChangeEvent;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Tools.SignEditor;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;

public class ACSignEditListener
implements Listener {
    private final Map<Location, SignEditor> signEditor = new HashMap<Location, SignEditor>();

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        if (event instanceof ACSignChangeEvent) {
            return;
        }
        Location signLoc = event.getBlock().getLocation();
        SignEditor saved = this.signEditor.get(signLoc);
        if (saved == null) {
            return;
        }
        Player player = event.getPlayer();
        ACSignChangeEvent signChange = new ACSignChangeEvent(saved.getUpdatedSignBlk(), player, event.getLines());
        Bukkit.getPluginManager().callEvent((Event)signChange);
        if (signChange.isCancelled()) {
            this.signEditor.remove(signLoc);
            return;
        }
        saved.updateSign(signChange.getLines());
        saved.removeEditorSign(player);
        this.signEditor.remove(signLoc);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void signPlace(BlockPlaceEvent event) {
        Block block = event.getBlockPlaced();
        if (block.getType() != Material.WALL_SIGN && block.getType() != Material.SIGN_POST) {
            return;
        }
        Block blockAgainst = event.getBlockAgainst();
        BlockState blockAgainstState = blockAgainst.getState();
        if (!(blockAgainstState instanceof Sign)) {
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)event.getPlayer(), "admincmd.spec.signedit")) {
            this.signEditor.put(block.getLocation(), new SignEditor(block, blockAgainst));
        }
    }
}

