/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners.Features;

import be.Balor.Tools.Debug.ACLogger;
import be.Balor.Tools.Utils;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.LocaleHelper;
import com.google.common.collect.MapMaker;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class ACIpCheckListener
implements Listener {
    private final ConcurrentMap<String, Player> ips = new MapMaker().makeMap();

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        InetAddress address = p.getAddress().getAddress();
        HashMap<String, String> replace = new HashMap<String, String>();
        Player sameIP = this.addIP(p, address);
        if (sameIP != null) {
            replace.put("player", Utils.getPlayerName(p));
            replace.put("player2", Utils.getPlayerName(sameIP));
            replace.put("ip", address.toString());
            this.broadcastIP(replace);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.removePlayer((PlayerEvent)event);
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        this.removePlayer((PlayerEvent)event);
    }

    private void broadcastIP(HashMap<String, String> replace) {
        String message = LocaleHelper.IP_BROADCAST.getLocale(replace);
        if (message == null) {
            return;
        }
        Bukkit.getServer().broadcast(message, "admincmd.spec.ipbroadcast");
        ACLogger.info(message);
    }

    private void removePlayer(PlayerEvent event) {
        Player player = event.getPlayer();
        this.updateIP(player, player.getAddress().getAddress());
    }

    private void updateIP(final Player quits, final InetAddress address) {
        ACPluginManager.scheduleAsyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                for (Player p : Utils.getOnlinePlayers()) {
                    if (p.equals(quits) || !p.getAddress().getAddress().equals(address)) continue;
                    ACIpCheckListener.this.ips.replace(address.toString(), p);
                    return;
                }
                ACIpCheckListener.this.ips.remove(address.toString());
            }
        });
    }

    private Player addIP(Player player, InetAddress address) {
        Player p = this.ips.putIfAbsent(address.toString(), player);
        return p;
    }

    public boolean ipInUse(InetAddress address) {
        return this.ips.containsKey(address.toString());
    }
}

