/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners.Commands;

import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Player.ACPlayer;
import be.Balor.Tools.Type;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;

public class ACFlyListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (!ACPlayer.getPlayer(p).hasPower(Type.FLY)) {
            return;
        }
        p.setAllowFlight(true);
        p.setFlying(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        if (!player.hasPower(Type.FLY_OLD)) {
            return;
        }
        Float power = Float.valueOf(player.getPower(Type.FLY_OLD).getFloat(0.0f));
        if (power.floatValue() != 0.0f) {
            if (p.isSneaking()) {
                p.setVelocity(p.getLocation().getDirection().multiply(power.floatValue()));
            } else if (ConfigEnum.GLIDE.getBoolean()) {
                Vector vel = p.getVelocity();
                vel.add(p.getLocation().getDirection().multiply(ConfigEnum.G_MULT.getFloat()).setY(0));
                if (vel.getY() < (double)ConfigEnum.G_VELCHECK.getFloat()) {
                    vel.setY(ConfigEnum.G_NEWYVEL.getFloat());
                    p.setVelocity(vel);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if ((ACPlayer.getPlayer(player).hasPower(Type.FLY) || ACPlayer.getPlayer(player).hasPower(Type.FLY_OLD)) && event.getCause().equals((Object)EntityDamageEvent.DamageCause.FALL)) {
            event.setCancelled(true);
            event.setDamage(0);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        Player p = event.getPlayer();
        if ((event.getReason().toLowerCase().contains("flying") || event.getReason().toLowerCase().contains("floating")) && PermissionManager.hasPerm((CommandSender)p, "admincmd.player.fly.allowed")) {
            event.setCancelled(true);
        }
    }
}

