/*
 * Decompiled with CFR 0.152.
 */
package be.Balor.Listeners;

import be.Balor.Manager.CommandManager;
import be.Balor.Manager.Exceptions.NoPermissionsPlugin;
import be.Balor.Manager.Permissions.PermissionManager;
import be.Balor.Manager.Permissions.Plugins.SuperPermissions;
import be.Balor.Player.ACPlayer;
import be.Balor.Player.PlayerManager;
import be.Balor.Tools.Debug.DebugLog;
import be.Balor.Tools.Type;
import be.Balor.Tools.Utils;
import be.Balor.World.ACWorld;
import be.Balor.bukkit.AdminCmd.ACHelper;
import be.Balor.bukkit.AdminCmd.ACPluginManager;
import be.Balor.bukkit.AdminCmd.ConfigEnum;
import be.Balor.bukkit.AdminCmd.TextLocale;
import belgium.Balor.Workers.AFKWorker;
import belgium.Balor.Workers.InvisibleWorker;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class ACPlayerListener
implements Listener {
    @EventHandler
    public void onPlayerChat(PlayerChatEvent event) {
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        if (ConfigEnum.AUTO_AFK.getBoolean()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
        if (player.hasPower(Type.MUTED)) {
            event.setCancelled(true);
            Utils.sI18n((CommandSender)p, "muteEnabled");
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String[] split;
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        String message = event.getMessage();
        if (player.hasPower(Type.MUTED_COMMAND) && (split = message.split("\\s+")).length != 0 && split[0].contains("/")) {
            event.setCancelled(true);
            Utils.sI18n((CommandSender)p, "commandMuteEnabled");
        }
        if (CommandManager.getInstance().processCommandString((CommandSender)event.getPlayer(), message)) {
            event.setCancelled(true);
            event.setMessage("/AdminCmd : " + message);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player p = event.getPlayer();
        if (ConfigEnum.AUTO_AFK.getBoolean()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player p = event.getPlayer();
        final ACPlayer player = PlayerManager.getInstance().setOnline(p);
        InvisibleWorker.getInstance().makeInvisibleToPlayer(p);
        InetAddress address = p.getAddress().getAddress();
        player.setInformation("last-ip", address.toString());
        HashMap<String, String> replace = new HashMap<String, String>();
        if (ConfigEnum.JQMSG.getBoolean() && !SuperPermissions.isApiSet()) {
            replace.put("name", Utils.getPlayerName(p, null, true));
            event.setJoinMessage(Utils.I18n("joinMessage", replace));
        }
        if (player.hasPower(Type.INVISIBLE)) {
            event.setJoinMessage(null);
            Utils.sI18n((CommandSender)p, "stillInv");
            InvisibleWorker.getInstance().vanish(p, true);
        }
        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                DebugLog.INSTANCE.info("ASync Task for optimization for " + p.getName());
                DebugLog.INSTANCE.info("AFK start");
                if (ConfigEnum.AUTO_AFK.getBoolean()) {
                    AFKWorker.getInstance().updateTimeStamp(p);
                }
                DebugLog.INSTANCE.info("AFK stop");
                DebugLog.INSTANCE.info("ImmunityLvl start");
                int imLvl = ACHelper.getInstance().getLimit(p, Type.Limit.IMMUNITY, "defaultImmunityLvl");
                player.setInformation("immunityLvl", imLvl == Integer.MAX_VALUE ? ConfigEnum.DIMMUNITY.getInt() : imLvl);
                DebugLog.INSTANCE.info("ImmunityLvl stop");
                DebugLog.INSTANCE.info("SPY start");
                if (player.hasPower(Type.SPYMSG)) {
                    ACHelper.getInstance().addSpy(p);
                }
                DebugLog.INSTANCE.info("SPY stop");
                DebugLog.INSTANCE.info("LastConn start");
                long lastConn = player.getInformation("lastConnection").getLong(0L);
                player.setInformation("lastConnection", System.currentTimeMillis());
                DebugLog.INSTANCE.info("LastConn stop");
                DebugLog.INSTANCE.info("TextLocale start");
                long modifTime = TextLocale.NEWS.getModifTime();
                if (ConfigEnum.NEWS.getBoolean() && (modifTime == 0L || lastConn <= modifTime)) {
                    Utils.sParsedLocale(p, "NEWS");
                }
                DebugLog.INSTANCE.info("TextLocale stop");
                DebugLog.INSTANCE.info("Rules start");
                if (ConfigEnum.RULES.getBoolean() && !ConfigEnum.FJ_RULES.getBoolean()) {
                    Utils.sParsedLocale(p, "Rules");
                }
                DebugLog.INSTANCE.info("Rules stop");
                DebugLog.INSTANCE.info("TPREQUEST start");
                if (ConfigEnum.TPREQUEST.getBoolean() && !player.hasPower(Type.TP_REQUEST) && PermissionManager.hasPerm((CommandSender)p, "admincmd.tp.toggle.allow", false)) {
                    player.setPower(Type.TP_REQUEST);
                }
                DebugLog.INSTANCE.info("TPREQUEST stop");
            }
        });
        if (player.hasPower(Type.FAKEQUIT)) {
            event.setJoinMessage(null);
            ACHelper.getInstance().addFakeQuit(p);
        }
        if (player.getInformation("firstTime").getBoolean(true)) {
            player.setInformation("firstTime", false);
            if (ConfigEnum.JQMSG.getBoolean() && !SuperPermissions.isApiSet()) {
                replace.clear();
                replace.put("name", Utils.getPlayerName(p, null, true));
                event.setJoinMessage(Utils.I18n("joinMessageFirstTime", replace));
            }
            if (ConfigEnum.FCSPAWN.getBoolean()) {
                ACHelper.getInstance().spawn(p);
            }
            if (!ConfigEnum.FCSPAWN.getBoolean() && ConfigEnum.GSPAWN.getString().equalsIgnoreCase("group")) {
                ACHelper.getInstance().groupSpawn((CommandSender)p);
            }
            if (ConfigEnum.FJ_RULES.getBoolean()) {
                Utils.sParsedLocale(p, "Rules");
            }
            if (ConfigEnum.MOTD.getBoolean()) {
                Utils.sParsedLocale(p, "MOTDNewUser");
            }
        } else if (ConfigEnum.MOTD.getBoolean()) {
            Utils.sParsedLocale(p, "MOTD");
        }
        DebugLog.INSTANCE.info("Player " + p.getName() + " joined sucessfully");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerLogin(PlayerLoginEvent event) {
        if (event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            return;
        }
        if (PermissionManager.hasPerm((CommandSender)event.getPlayer(), "admincmd.player.bypass", false) && event.getResult() == PlayerLoginEvent.Result.KICK_FULL) {
            event.allow();
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        if (ConfigEnum.AUTO_AFK.getBoolean()) {
            AFKWorker.getInstance().updateTimeStamp(p);
            if (AFKWorker.getInstance().isAfk(p)) {
                AFKWorker.getInstance().setOnline(p);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        ACPlayer player = ACPlayer.getPlayer(event.getPlayer());
        if (player.hasPower(Type.NO_PICKUP)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerKick(PlayerKickEvent event) {
        Player p = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(p);
        if (player != null && player.hasPower(Type.KICKED)) {
            event.setLeaveMessage(null);
            player.removePower(Type.KICKED);
        }
        ACHelper.getInstance().removeDisconnectedPlayer(p);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerQuit(PlayerQuitEvent event) {
        final Player p = event.getPlayer();
        final ACPlayer player = ACPlayer.getPlayer(p);
        player.setInformation("lastDisconnect", System.currentTimeMillis());
        ACPluginManager.getScheduler().scheduleAsyncDelayedTask((Plugin)ACPluginManager.getCorePlugin(), new Runnable(){

            @Override
            public void run() {
                int imLvl = ACHelper.getInstance().getLimit(p, Type.Limit.IMMUNITY, "defaultImmunityLvl");
                player.setInformation("immunityLvl", imLvl == Integer.MAX_VALUE ? ConfigEnum.DIMMUNITY.getInt() : imLvl);
            }
        });
        if (ConfigEnum.JQMSG.getBoolean() && !SuperPermissions.isApiSet()) {
            HashMap<String, String> replace = new HashMap<String, String>();
            replace.put("name", Utils.getPlayerName(p, null, true));
            event.setQuitMessage(Utils.I18n("quitMessage", replace));
        }
        if (player.hasPower(Type.FAKEQUIT)) {
            event.setQuitMessage(null);
        } else if (InvisibleWorker.getInstance().hasInvisiblePowers(p)) {
            event.setQuitMessage(null);
        }
        player.setInformation("gameMode", p.getGameMode());
        PlayerManager.getInstance().setOffline(player);
        ACHelper.getInstance().removeDisconnectedPlayer(p);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        String spawn = ConfigEnum.GSPAWN.getString();
        Location loc = null;
        String worldName = player.getWorld().getName();
        if (spawn.isEmpty() || spawn.equalsIgnoreCase("globalspawn")) {
            loc = ACWorld.getWorld(worldName).getSpawn();
            event.setRespawnLocation(loc);
        } else if (spawn.equalsIgnoreCase("home")) {
            loc = ACPlayer.getPlayer(player).getHome(worldName);
            if (loc == null) {
                loc = ACWorld.getWorld(worldName).getSpawn();
            }
            event.setRespawnLocation(loc);
        } else if (spawn.equalsIgnoreCase("bed")) {
            try {
                loc = player.getBedSpawnLocation();
                if (loc == null) {
                    loc = ACWorld.getWorld(worldName).getSpawn();
                }
            }
            catch (NullPointerException e) {
                loc = ACWorld.getWorld(worldName).getSpawn();
            }
            event.setRespawnLocation(loc);
        } else if (spawn.equalsIgnoreCase("group")) {
            Iterator<String> i$;
            List<String> groups = ACHelper.getInstance().getGroupList();
            if (!groups.isEmpty() && (i$ = groups.iterator()).hasNext()) {
                String groupName = i$.next();
                try {
                    if (PermissionManager.isInGroup(groupName, player)) {
                        loc = ACWorld.getWorld((String)worldName).getWarp((String)new StringBuilder().append((String)"spawn").append((String)groupName.toLowerCase()).toString()).loc;
                    }
                }
                catch (NoPermissionsPlugin e) {
                    loc = ACWorld.getWorld(worldName).getSpawn();
                }
            }
            if (loc == null) {
                loc = ACWorld.getWorld(worldName).getSpawn();
            }
            event.setRespawnLocation(loc);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        ACPlayer player = ACPlayer.getPlayer(event.getPlayer());
        if (player.hasPower(Type.FROZEN)) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player bPlayer = event.getPlayer();
        ACPlayer player = ACPlayer.getPlayer(bPlayer);
        if (player.hasPower(Type.FLY)) {
            bPlayer.setAllowFlight(true);
            bPlayer.setFlying(true);
        }
    }
}

